<?php

namespace App\Console\Commands;

use App\Jobs\DeleteFileJob;
use Illuminate\Support\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class DeleteOldBulkInvoiceFile extends Command
{
    protected $signature = 'file:delete-old-bulk-invoice';
    protected $description = 'Deletes files older than one minute.';

    public function handle()
    {
        $disk = 'bulk_invoice_files';
        $allFiles = Storage::disk($disk)->allFiles();
        foreach ($allFiles as $file) {
            $fileTimestamp = Storage::disk($disk)->lastModified($file);
            if (Storage::disk($disk)->exists($file) && Carbon::createFromTimestamp($fileTimestamp)->addYears(2)->isPast()) {
                dispatch(new DeleteFileJob($file, $disk))->onQueue('default');
                Log::info('Bulk invoice deleted: ' . $file);
            } else {
               // Log::info('File not found or not yet old enough: ' . $file);
            }
        }
    }
}
