<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\Customers\DeleteUserBootMessageJob;
use App\Models\WhatsappGateway\WhatsappGatewayGeneral;

class DeleteUserBootMessage extends Command
{
    protected $signature = 'bootmessage:process-delete-user-boot-message';
    protected $description = 'Processing delete user boot message';

    public function handle()
    {
        if (!WhatsappGatewayGeneral::first()->disabled) {
            if (cache()->get('delete_user_boot_message')) {
                $this->warn('Processing delete user boot message is already running');
                return Command::FAILURE;
            }

            cache()->put('delete_user_boot_message', true, 60); // Lock for 60 minutes

            try {

                $this->info('Processing delete user boot message...');
                dispatch(new DeleteUserBootMessageJob())->onQueue('default');
                cache()->forget('delete_user_boot_message');
                return Command::SUCCESS;
            } catch (\Exception $e) {
                cache()->forget('delete_user_boot_message');
                $this->error("Error processing delete user boot message: " . $e->getMessage());
                return Command::FAILURE;
            }
        }
    }
}
