<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Jobs\Billings\ProcessSubscriptionsBillingJob;


class ProcessSubscriptionBilling extends Command
{
    protected $signature = 'invoices:create-invoices';
    protected $description = 'Processing create new invoices';

    public function handle()
    {
        if (cache()->get('processing_subscription_billing')) {
            $this->warn('Processing create new invoices is already running');
            return Command::FAILURE;
        }

        cache()->put('processing_subscription_billing', true, 60); // Lock for 60 minutes

        try {

            $this->info('Processing create new invoices...');
            Log::info('Processing create new invoices...');
            dispatch(new ProcessSubscriptionsBillingJob())->onQueue('default');
            cache()->forget('processing_subscription_billing');
            return Command::SUCCESS;
        } catch (\Exception $e) {
            cache()->forget('processing_subscription_billing');
            $this->error("Error processing reminders: " . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
