<?php

namespace App\Handler;

use App\Models\UserAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\WhatsappGateway\WhatsappGatewayGeneral;
use Spatie\WebhookClient\WebhookProfile\WebhookProfile;

class ProcessGriyanetWebhookProfile implements WebhookProfile
{
    public function shouldProcess(Request $request): bool
    {
        $waGateway = WhatsappGatewayGeneral::first();
        if ($waGateway->isDisable() || strlen($request->message) <= 0 || $request->receipt != $waGateway->bootNumberMessage()) return false;
        return true;
    }
}
