<?php

namespace App\Handler;

use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Billings\Order;
use Spatie\WebhookClient\WebhookProfile\WebhookProfile;

class ProcessTripayWebhookProfile implements WebhookProfile
{
    public function shouldProcess(Request $request): bool
    {
        if ($request->is_closed_payment != 1) {
            return false;
        }

        $order = Order::whereMerchantRef($request->merchant_ref)
            ->wherePaymentGatewayChannel('tripay')
            ->wherePaymentMethod($request->payment_method_code)
            ->whereAmount($request->total_amount)
            ->first();


        $status = Str::lower($request->status);

        switch ($status) {
            // handle status PAID
            case 'paid':
                // $status = 'paid';
                $message = 'Payment successfully';
                break;
            // handle status EXPIRED
            case 'expired':
                // $status = 'expired';
                $message = 'Payment expired';
                break;
            // handle status FAILED
            case 'failed':
                // $status = 'failed';
                $message = 'Payment failed';
                break;
            case 'refund':
                // $status = 'refund';
                $message = 'Payment refund';
                break;
            case 'unpaid':
                // $status = 'unpaid';
                $message = 'Payment unpaid';
                break;
            default:
                return false;
        }


        if ($order && $status != 'paid') {
            $order->forceFill(['status' => $status])->save();
            $invoice = $order->invoice;
            if ($invoice) {
                $invoiceExpired = Carbon::parse($invoice->due_date)->isPast();
                $invoice->forceFill(['status' => $invoiceExpired ? 'overdue' : 'unpaid'])->save();
            }
            return false;
        }
        return true;
    }
}
