<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Container\Attributes\Auth;
use Symfony\Component\HttpFoundation\Response;

class SetDynamicLayout
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        //Set layout to admin or customer
        if (env('APP_INSTALLED') === false) {
            Config::set('livewire.layout', 'components.layouts.install');
        } else {

            if (auth()->check()) {
                if (auth()->user()->hasRole('customer')) {
                    Config::set('livewire.layout', 'components.layouts.app-customer');
                } else {
                    Config::set('livewire.layout', 'components.layouts.app-admin');
                }
            } else {
                Config::set('livewire.layout', 'components.layouts.auth');
            }
        }

        return $next($request);
    }
}
