<?php

namespace App\Http\Requests\Paket;

use App\Models\Pakets\Paket;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

class EditPaketStep2Request
{
    /**
     * Validate and create a newly registered customer.
     *
     * @param  array<string, string>  $input
     */
    public function validate(Paket $paket, array $input): array
    {
       Validator::make($input, [
            'name' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'unique:pakets,name,' . $paket->id . ',id,mikrotik_id,' . $paket->mikrotik_id,
            ],
            //'name' => 'unique:pakets,name,null,null,mikrotik_id,' . $request->mikrotik_id,
            'price' => ['required', 'numeric'],
            'description' => ['nullable', 'string', 'min:10', 'max:255'],
            'current_password' => ['required', 'string', 'current_password:web'],
        ])->validate();

        return $input;
        // return true;
    }
}
