<?php

namespace App\Jobs\Billings;

use Illuminate\Support\Facades\Log;
use App\Models\Customers\CustomerPaket;
use App\Services\Billings\BillingService;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class ProcessSubscriptionBillingJob implements ShouldQueue
{
    use Queueable;
    protected CustomerPaket $customerPaket;
    /**
     * Create a new job instance.
     */
    public function __construct($customerPaket)
    {
         $this->customerPaket = $customerPaket;
    }

    /**
     * Execute the job.
     */
    public function handle(BillingService $billingService): void
    {
        //Log::info($this->customerPaket);
        $billingService->generateInvoice($this->customerPaket);
    }
}
