<?php

namespace App\Jobs\Billings;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\Customers\CustomerPaket;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class ProcessSubscriptionsBillingJob implements ShouldQueue
{
    use Queueable;

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        CustomerPaket::where('status', 'active')
            ->where('auto_renew', true)
            ->where('price', '>', 0)
            ->get()
            ->each(function ($customerPaket) {
                $nextBilledAt =  Carbon::parse($customerPaket->next_billed_at);
                if ($customerPaket->needsBilling($nextBilledAt)) {
                    Log::info($customerPaket->user->full_name . ' need invoice.');
                    dispatch(new ProcessSubscriptionBillingJob($customerPaket))->onQueue('default');
                }
            });
    }
}
