<?php

namespace App\Jobs\Billings;

use App\Services\CustomerPaketService;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class SynchronizationNextBillJob implements ShouldQueue
{
    use Queueable;
    protected $customerPaket;
    /**
     * Create a new job instance.
     */
    public function __construct($customerPaket)
    {
         $this->customerPaket = $customerPaket;
    }

    /**
     * Execute the job.
     */
    public function handle(CustomerPaketService $customerPaketService): void
    {
        $customerPaketService->syncronize_next_billed_at($this->customerPaket);
    }
}
