<?php

namespace App\Jobs\Customers;

use App\Models\UserAddress;
use Illuminate\Support\Str;
use App\Models\Pakets\PppType;
use Illuminate\Support\Carbon;
use App\Models\Servers\Mikrotik;
use Illuminate\Support\Facades\DB;
use App\Models\Pakets\PaketProfile;
use Illuminate\Support\Facades\Log;
use App\Models\Customers\UserCustomer;
use App\Services\Billings\BillingService;
use App\Livewire\Actions\Users\UserAction;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Models\Customers\CustomerPaketStatusLatest;
use App\Jobs\Billings\ProcessSubscriptionBillingJob;
use App\Jobs\Billings\ProcessSubscriptionsBillingJob;
use App\Livewire\Actions\Customers\CustomerPaketAction;
//use App\Services\Mikrotiks\MikrotikPppUserSecretService;

class ImportCustomerFromMikrotikJob implements ShouldQueue
{
    use Queueable;

    private Mikrotik $mikrotik;

    private $userSecret;
    private $input;
    /**
     * Create a new job instance.
     */
    public function __construct(Mikrotik $mikrotik, $userSecret, array $input)
    {
        $this->mikrotik = $mikrotik;
        $this->userSecret = $userSecret;
        $this->input = $input;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        DB::beginTransaction();
        try {
            $str = Str::random(2);
            $input = [
                'first_name' => $this->userSecret['name'],
                'email' => $this->userSecret['name'] . '_' . Str::slug($str, '_') . '@' . $this->input['email_domain'],
                'password' => $str,
                'disabled' => false,
            ];

            $user = (new UserAction())->addUser($input);
            $user->activation();
            $user->assignRole('customer');

            $userAddress = new UserAddress();
            $user->user_address()->save($userAddress);

            $userCustomer = new UserCustomer();
            $user->user_address()->save($userCustomer);

            $paketProfile = PaketProfile::where('profile_name', $this->userSecret['profile'])->first();
            $paket = $paketProfile->mikrotik_paket($this->mikrotik);

            $input = array_merge([
                'selectedPaket' => $paket->id,
                'selectedInternetService' => 'ppp',
                'activation_date' => $this->input['activation_date'],
                'renewal_period' => $this->input['renewal_period'],
                'usernamePpp' => $this->userSecret['name'],
                'passwordPpp' => $this->userSecret['password'],
                'secret_id' => $this->userSecret['.id'],
                'disabled' => $this->userSecret['disabled'],
                'selectedPppService' =>  PppType::where('name', $this->userSecret['service'])->first()->id,
                'useCommentActivationDate' => $this->input['use_comment_activation_date'],
                'comment' => empty($this->userSecret['comment'] ?? false) ? null : $this->userSecret['comment']
            ]);

            $customerPaket = (new CustomerPaketAction())->importCustomerPaket($user, $input);

           // $customerPaketStatusLatest = new CustomerPaketStatusLatest();
          //  $customerPaket->customer_paket_status_latest()->save($customerPaketStatusLatest);
            $nextBilledAt =  Carbon::parse($customerPaket->next_billed_at);
            if ($customerPaket->needsBilling($nextBilledAt)) {
                Log::info($customerPaket->user->full_name . ' need invoice.');
                dispatch(new ProcessSubscriptionBillingJob($customerPaket))->onQueue('default');
            }
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            Log::info($e->getMessage());
        }
    }
}
