<?php

namespace App\Jobs;

use App\Models\Address;
use App\Models\Customers\CustomerPaketAddress;
use App\Models\UserAddress;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class ImportAddressJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        Log::info('Running import address');
        $userAddresses = UserAddress::all();
        foreach ($userAddresses as $userAddress) {
            $userCountry = $userAddress->country;
            if ($userCountry && $userCountry === 'id') {
                $countryName = 'Indonesia';
                $existCountry = Address::whereName($countryName)->first();
                if ($existCountry) {
                    $countryId = $existCountry->id;
                } else {
                    $newCountry = Address::create([
                        'name' => $countryName,
                        'description' => 'country'
                    ]);
                    $countryId = $newCountry->id;
                }
                $userAddress->forceFill([
                    'country' => $countryName
                ])->save();
                $userProvince = json_decode($userAddress->province, true);
                if ($userProvince) {
                    $provinceName = $userProvince['text'] ?? $userAddress->province;
                    $existProvince = Address::whereName($provinceName)->first();
                    if ($existProvince) {
                        $provinceId = $existProvince->id;
                    } else {
                        $newProvince = Address::create([
                            'address_id' => $countryId,
                            'name' => $provinceName,
                            'description' => 'province'
                        ]);
                        $provinceId = $newProvince->id;
                    }
                    $userAddress->forceFill([
                        'province' => $provinceName
                    ])->save();

                    $userCity = json_decode($userAddress->city, true);
                    if ($userCity) {
                        $cityName = $userCity['text'] ?? $userAddress->city;
                        $existCity = Address::whereName($cityName)->whereAddressId($provinceId)->first();
                        if ($existCity) {
                            $cityId = $existCity->id;
                        } else {
                            $newCity = Address::create([
                                'address_id' => $provinceId,
                                'name' => $cityName,
                                'description' => 'city'
                            ]);
                            $cityId = $newCity->id;
                        }
                        $userAddress->forceFill([
                            'city' => $cityName
                        ])->save();

                        $userDistrict = json_decode($userAddress->district, true);
                        if ($userDistrict) {
                            $districtName = $userDistrict['text'] ?? $userAddress->district;
                            $existDistrict = Address::whereName($districtName)->whereAddressId($cityId)->first();
                            if ($existDistrict) {
                                $districtId = $existDistrict->id;
                            } else {
                                $newDistrict = Address::create([
                                    'address_id' => $cityId,
                                    'name' => $districtName,
                                    'description' => 'district'
                                ]);
                                $districtId = $newDistrict->id;
                            }
                            $userAddress->forceFill([
                                'district' => $districtName
                            ])->save();

                            $userSubdistrict = json_decode($userAddress->subdistrict, true);
                            if ($userSubdistrict) {
                                $subdistrictName = $userSubdistrict['text'] ?? $userAddress->subdistric;
                                $existSubdistrict = Address::whereName($subdistrictName)->whereAddressId($districtId)->first();
                                if ($existSubdistrict) {
                                    $subdistrictId = $existSubdistrict->id;
                                } else {
                                    $newSubdistrict = Address::create([
                                        'address_id' => $districtId,
                                        'name' => $subdistrictName,
                                        'description' => 'subdistrict'
                                    ]);
                                    $subdistrictId = $newSubdistrict->id;
                                }
                                $userAddress->forceFill([
                                    'subdistrict' => $subdistrictName
                                ])->save();
                            }
                        }
                    }
                }
            }
        }

        $customerPaketAddresses = CustomerPaketAddress::all();
        foreach ($customerPaketAddresses as $customerPaketAddress) {
            $customerPaketCountry = $customerPaketAddress->country;
            if ($customerPaketCountry && $customerPaketCountry === 'id') {
                $countryName = 'Indonesia';
                $existCountry = Address::whereName($countryName)->first();
                if ($existCountry) {
                    $countryId = $existCountry->id;
                } else {
                    $newCountry = Address::create([
                        'name' => $countryName,
                        'description' => 'country'
                    ]);
                    $countryId = $newCountry->id;
                }
                $userAddress->forceFill([
                    'country' => $countryName
                ])->save();
                $customerPaketAddressProvince = json_decode($customerPaketAddress->province, true);
                if ($customerPaketAddressProvince) {
                    $provinceName = $customerPaketAddressProvince['text'] ?? $customerPaketAddress->province;
                    $existProvince = Address::whereName($provinceName)->first();
                    if ($existProvince) {
                        $provinceId = $existProvince->id;
                    } else {
                        $newProvince = Address::create([
                            'address_id' => $countryId,
                            'name' => $provinceName,
                            'description' => 'province'
                        ]);
                        $provinceId = $newProvince->id;
                    }
                    $customerPaketAddress->forceFill([
                        'province' => $provinceName
                    ])->save();

                    $customerPaketAddressCity = json_decode($customerPaketAddress->city, true);
                    if ($customerPaketAddressCity) {
                        $cityName = $customerPaketAddressCity['text'] ?? $customerPaketAddress->city;
                        $existCity = Address::whereName($cityName)->whereAddressId($provinceId)->first();
                        if ($existCity) {
                            $cityId = $existCity->id;
                        } else {
                            $newCity = Address::create([
                                'address_id' => $provinceId,
                                'name' => $cityName,
                                'description' => 'city'
                            ]);
                            $cityId = $newCity->id;
                        }
                        $customerPaketAddress->forceFill([
                            'city' => $cityName
                        ])->save();

                        $customerPaketAddressDistrict = json_decode($customerPaketAddress->district, true);
                        if ($customerPaketAddressDistrict) {
                            $districtName = $customerPaketAddressDistrict['text'] ?? $customerPaketAddress->district;
                            $existDistrict = Address::whereName($districtName)->whereAddressId($cityId)->first();
                            if ($existDistrict) {
                                $districtId = $existDistrict->id;
                            } else {
                                $newDistrict = Address::create([
                                    'address_id' => $cityId,
                                    'name' => $districtName,
                                    'description' => 'district'
                                ]);
                                $districtId = $newDistrict->id;
                            }
                            $customerPaketAddress->forceFill([
                                'district' => $districtName
                            ])->save();

                            $customerPaketAddressSubdistrict = json_decode($customerPaketAddress->subdistrict, true);
                            if ($customerPaketAddressSubdistrict) {
                                $subdistrictName = $customerPaketAddressSubdistrict['text'] ?? $customerPaketAddress->subdistrict;
                                $existSubdistrict = Address::whereName($subdistrictName)->whereAddressId($districtId)->first();
                                if ($existSubdistrict) {
                                    $subdistrictId = $existSubdistrict->id;
                                } else {
                                    $newSubdistrict = Address::create([
                                        'address_id' => $districtId,
                                        'name' => $subdistrictName,
                                        'description' => 'subdistrict'
                                    ]);
                                    $subdistrictId = $newSubdistrict->id;
                                }
                                $customerPaketAddress->forceFill([
                                    'subdistrict' => $subdistrictName
                                ])->save();
                            }
                        }
                    }
                }
            }
        }
    }
}
