<?php

namespace App\Jobs\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use App\Services\GeneralLogServices;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendInvoiceReminderJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $customerPaket, $intervalDay;

    public function __construct($customerPaket, $intervalDay)
    {
        $this->customerPaket = $customerPaket;
        $this->intervalDay = $intervalDay;
    }
    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService, GeneralLogServices $generalLogServices): void
    {
        Log::info('Running Job Send reminder to: ' . $this->customerPaket->user->full_name . ' ' . $this->customerPaket->customer_billing_address->phone);
        $whatsappNotificationService->sendUpcomingDueReminders($this->customerPaket, $this->intervalDay);
        $generalLogServices->send_customer_notification($this->customerPaket, $generalLogServices::NOTIFIACTION_REMINDER_PAYMENT);
        $this->customerPaket->customer_billing_address->forceFill([
            'last_reminder_date' => Carbon::now()
        ])->save();
    }
}
