<?php

namespace App\Jobs\Notifications;

use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendNotificationCustomerPaketConnectionStatusJob implements ShouldQueue
{
    use Queueable;

    protected $customerPaket, $lastStatus;
    public function __construct($customerPaket, $lastStatus)
    {
        $this->customerPaket = $customerPaket;
        $this->lastStatus = $lastStatus;
    }

    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService): void
    {
        $whatsappNotificationService->sendStatusConnectionNotification($this->customerPaket, $this->lastStatus);
    }
}
