<?php

namespace App\Jobs\Notifications;

use App\Services\CustomerPaketService;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendNotificationSubscriptionStatusChangeJob implements ShouldQueue
{
    use Queueable;

    protected $customerPaket, $function, $generalLog;
    public function __construct($customerPaket, $function, $generalLog = null)
    {
        $this->customerPaket = $customerPaket;
        $this->function = $function;
        $this->generalLog = $generalLog;
    }

    /**
     * Execute the job.
     */
    public function handle(CustomerPaketService $customerPaketService): void
    {
        $customerPaketService->send_whatsapp_notification_to_installation_address($this->customerPaket, $this->function, $this->generalLog);
    }
}
