<?php

namespace App\Jobs\Notifications;

use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendNotificationUnpaymentJob implements ShouldQueue
{
    use Queueable;

    protected $payment, $refundedAmount;
    public function __construct($payment, $refundedAmount)
    {
        $this->payment = $payment;
        $this->refundedAmount = $refundedAmount;
    }

    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService): void
    {
        $whatsappNotificationService->sendUnpaymentNotification($this->payment, $this->refundedAmount);
    }
}
