<?php

namespace App\Livewire\Actions\Users;

use App\Models\User;
use App\Models\UserAddress;
use App\Traits\StandardPhoneNumber;
use App\Livewire\Actions\Customers\CustomerPaketAddressAction;


class UserAddressAction
{
    use StandardPhoneNumber;
    /**
     * Validate and create a newly address user.
     *
     * @param  array<string, string>  $input
     */

    public function addUserAddress(User $user, array $input): UserAddress
    {
        $userAddress = new UserAddress();
        $user->user_address()->save($userAddress);
        $this->updateUserAddress($user, $input);
        return $userAddress;
    }

    public function addInstallationAddress(User $user, array $input): UserAddress
    {
        $userAddress = $user->user_address;
        if ($input['checkbox_address_installation']) {
            $installationAddress = new UserAddress();
            $user->user_address()->save($userAddress);
            $this->updateUserAddress($user, $input);
        } else {
            $installationAddress = $userAddress->replicate();
            $installationAddress->address_type = $input["address_type"];
            $installationAddress->save();
        }
        return  $installationAddress;
    }

    public function addBillingAddress(User $user, array $input): UserAddress
    {
        $userAddress = $user->user_address;
        if ($input['checkbox_address_billing']) {
            $billingAddress = new UserAddress();
            $user->user_address()->save($billingAddress);
            $this->updateUserAddress($user, $input);
        } else {
            $billingAddress = $userAddress->replicate();
            $billingAddress->address_type = $input["address_type"];
            $billingAddress->save();
        }
        return $billingAddress;
    }
    public function updateUserAddress(User $user, array $input, $changeInstallationAddress = false, $changeBillingAddress = false)
    {
        //$input['phone'] ?? $input['phone'] = $user->user_address->phone;
        //if ($input['phone']) $input['phone'] = $this->internationalPhoneNumberFormat($input['phone']);
        $user->user_address->forceFill([
            'country' => $input['country'] ?? null,
            'province' => $input['province'] ?? null,
            'city' => $input['city'] ?? null,
            'district' => $input['district'] ?? null,
            'subdistrict' => $input['subdistrict'] ?? null,
            'phone' => empty($input['phone'] ?? false) ? null : $this->internationalPhoneNumberFormat($input['phone']),
            'address' => $input['address'] ?? null,
        ])->save();

        foreach ($user->customer_pakets as $customer_paket) {
            if ($changeInstallationAddress) {
                $inputInstallationAddress = [
                    'installation_country' => $input['country'] ?? null,
                    'installation_province' => $input['province'] ?? null,
                    'installation_city' => $input['city'] ?? null,
                    'installation_district' => $input['district'] ?? null,
                    'installation_subdistrict' => $input['subdistrict'] ?? null,
                    'installation_phone' => empty($input['phone'] ?? false) ? null : $this->internationalPhoneNumberFormat($input['phone']),
                    // 'phone' => $input['phone'],
                    'installation_address' => $input['address'] ?? null,
                ];
                (new CustomerPaketAddressAction())->updateInstallationAddress($customer_paket->customer_installation_address, $inputInstallationAddress);
            }

            if ($changeBillingAddress) {
                $inputBillingAddress = [
                'billing_country' => $input['country'] ?? null,
                'billing_province' => $input['province'] ?? null,
                'billing_city' => $input['city'] ?? null,
                'billing_district' => $input['district'] ?? null,
                'billing_subdistrict' => $input['subdistrict'] ?? null,
                'billing_phone' => empty($input['phone'] ?? false) ? null : $this->internationalPhoneNumberFormat($input['phone']),
                'billing_address' => $input['address'] ?? null,
                ];
                (new CustomerPaketAddressAction())->updateBillingAddress($customer_paket->customer_billing_address, $inputBillingAddress);
            }
        }
    }
}
