<?php

namespace App\Livewire\Admin\Billings\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Billings\Invoice;
use Illuminate\Support\Facades\Auth;
use App\Livewire\Actions\Billings\InvoiceAction;
use App\Http\Requests\Billings\AddDiscountRequest;


class AddDiscount extends Component
{
    use NotificationTrait;
    public $input = [];
    public Invoice $invoice;
    public $addDiscountModal = false;


    #[On('add-discount-modal')]
    public function showAddDiscountModal($invoice)
    {
        if (Auth::user()->can('invoice payment') || Auth::user()->hasRole('admin')) {
            $invoice = Invoice::findOrFail($invoice);
            $this->invoice = $invoice;
            $this->addDiscountModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }


    public function add_discount(AddDiscountRequest $request, InvoiceAction $invoiceAction)
    {
        $remainingAmount = $this->invoice->remaining_amount;
        $request->validate($this->input, $remainingAmount);
        $addDiscount = $invoiceAction->add_discount(
            $this->invoice,
            $this->input['discount']
        );

        $this->addDiscountModal = false;
        $this->dispatch('refresh-billing-paket');
        if ($addDiscount['success']) {
            $title = trans('billing.alert.payment-success-title');
            $message = trans('billing.alert.payment-success-message', ['paket' => $this->invoice->customer_paket->paket->name, 'customer' =>  $this->invoice->customer_paket->user->full_name]);
            $this->success_notification($title, $message);
        } else {
            $this->error_notification('Failed', $addDiscount['message']);
        }
    }

    public function render()
    {
        return view('livewire.admin.billings.modal.add-discount');
    }
}
