<?php

namespace App\Livewire\Admin\Billings\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Billings\Invoice;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;
use App\Services\Billings\ExportInvoiceService;

class CreateInvoicesModal extends Component
{
    use NotificationTrait;
    public $createInvoicesModal = false;
    public $selectedBillings;
    public $search_address = '';
    public $search_with_periode = 'all-periode';
    public $sortField = 'billing_address';
    public $fileExist = false;
    public $invoicesFile;
    public $invoices;

    #[On('show-create-invoices-modal')]
    public function showCreateInvoicesModal()
    {
        if (Auth::user()->can('invoice action') || Auth::user()->hasRole('admin')) {
            $this->createInvoicesModal = true;
            $this->invoices = collect();
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public $invoice;
    public function exportInvoices(ExportInvoiceService $exportInvoiceService)
    {
        $this->invoicesFile = $exportInvoiceService->create_invoices_file($this->invoices);
        $this->fileExist = $exportInvoiceService->ceckFile($this->invoicesFile, 'bulk_invoice_files');
    }

    public function download_invoices(ExportInvoiceService $exportInvoiceService)
    {
        $response = $exportInvoiceService->download_file($this->invoicesFile, 'bulk_invoice_files');
        if (!$response) {
            $this->error_notification('Failed!', 'Invoice file not found.');
        } else {
            $this->createInvoicesModal = false;
            return $response;
        }
    }

    private function get_users_billing()
    {
        return CustomerPaket::with(['invoices' => function ($builder) {
            $builder->where('invoices.status', '!=', 'paid');
            $builder->when($this->search_with_periode, function ($builder) {
                $builder->where(function ($builder) {
                    if ($this->search_with_periode != "all-periode") {
                        $builder->where('periode', $this->search_with_periode);
                    }
                });
            });
            $builder->orderBy('periode')->orderBy('due_date');
        }])
            // ->whereHas('invoices')
            ->whereHas('invoices', function ($builder) {
                $builder->where('invoices.status', '!=', 'paid');
                $builder->when($this->search_with_periode, function ($builder) {
                    $builder->where(function ($builder) {
                        if ($this->search_with_periode != "all-periode") {
                            $builder->where('periode', $this->search_with_periode);
                        }
                    });
                });
            })
            ->with('customer_paket_addresses')
            ->whereHas('customer_paket_addresses', function ($builder) {
                $builder->when($this->search_address, function ($builder) {
                    $builder->where('address', 'like', '%' . $this->search_address . '%')
                        ->where('address_type', 'billing-address');
                });
            })
            ->get();
    }

    public function updatedSearchWithPeriode()
    {
        $this->invoices = $this->get_users_billing();
    }

    public function updatedSearchAddress()
    {
        $this->invoices = $this->get_users_billing();
    }

    public function render()
    {
        $periodes = Invoice::where('status', '!=', 'paid')
            ->select('periode')
            ->distinct('periode')
            ->orderBy('periode', 'asc')
            ->get();

        return view('livewire.admin.billings.modal.create-invoices-modal', [
            'periodes' => $periodes
        ]);
    }
}
