<?php

namespace App\Livewire\Admin\Billings\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Services\Billings\BillingService;
use App\Jobs\Billings\ProcessSubscriptionsBillingJob;

class CreateNewBillings extends Component
{
    use NotificationTrait;
    public $input = [];
    public $createNewBillingsModal = false;

    #[On('create-new-billings-modal')]
    public function showCreateNewBillingsModal()
    {
        if (Auth::user()->can('invoice action') || Auth::user()->hasRole('admin')) {
            $this->createNewBillingsModal = true;
            if (env('QUEUE_CONNECTION') == 'sync') {
                (new BillingService)->createInvoiceWithChunk();
            } else {
                dispatch(new ProcessSubscriptionsBillingJob())->onQueue('default');
            }

            $message =  trans('billing.alert.create-billing-succesfully');
            $this->success_notification(trans('billing.alert.success'), $message);
            $this->dispatch('refresh-billing-paket');
            $this->createNewBillingsModal = false;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function render()
    {
        return view('livewire.admin.billings.modal.create-new-billings');
    }
}
