<?php

namespace App\Livewire\Admin\Billings\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use App\Jobs\Notifications\SendInvoicesReminderJob;

class SendNotifications extends Component
{
    use NotificationTrait;
    public $sendNotificationsModal = false;

    #[On('send-notification-modal')]
    public function send_notifications_modal()
    {
        if (Auth::user()->can('invoice payment') || Auth::user()->hasRole('admin')) {
            $this->sendNotificationsModal = true;
            dispatch(new SendInvoicesReminderJob())->onQueue('default');
            $message =  trans('billing.alert.send-notification-succesfully');
            $this->success_notification(trans('billing.alert.success'), $message);
            $this->dispatch('refresh-billing-paket');
            $this->sendNotificationsModal = false;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function render()
    {
        return view('livewire.admin.billings.modal.send-notifications');
    }
}
