<?php

namespace App\Livewire\Admin\Billings\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use App\Models\Websystem;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;
use Illuminate\Support\Facades\Validator;
use App\Jobs\Billings\SynchronizationNextBillJob;

class Setting extends Component
{
    use NotificationTrait;
    public $billingSettingModal = false;
    public $input = [];
    public Websystem $websystem;

    #[On('billing-setting-modal')]
    public function showBillingSettingModal()
    {
        if (Auth::user()->can('configurations management') || Auth::user()->hasRole('admin')) {
            $this->websystem = Websystem::first();
            $this->input['diff_day'] = $this->websystem->different_day_create_billing;
            $this->input['tax_rate'] = $this->websystem->tax_rate;
            $this->input['subscription_type'] = $this->websystem->subscription_mode;
            $this->billingSettingModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function closeModal()
    {
        $this->billingSettingModal = false;
        $this->dispatch('refresh-billing-paket');
    }

    public function updateConfiguration()
    {
        Validator::make($this->input, [
            'diff_day' => ['numeric', 'max:15', 'required'],
            'tax_rate' => ['required', 'numeric', 'max:100'],
        ])->validate();

        $this->websystem->forceFill([
            'different_day_create_billing' => $this->input['diff_day'],
            'tax_rate' => $this->input['tax_rate'] ?? 0,
            'subscription_mode' => $this->input['subscription_type']
        ])->save();

        $customerPakets = CustomerPaket::all();
        foreach ($customerPakets as $customerPaket) {
            dispatch(new SynchronizationNextBillJob($customerPaket))->onQueue('default');
        }

        $this->closeModal();
    }
    public function render()
    {
        return view('livewire.admin.billings.modal.setting');
    }
}
