<?php

namespace App\Livewire\Admin\Billings\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Billings\Invoice;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Livewire\Actions\Billings\InvoiceAction;
use App\Http\Requests\Billings\AddDiscountRequest;


class SubDiscount extends Component
{
    use NotificationTrait;
    public $input = [];
    public Invoice $invoice;
    public $subDiscountModal = false;


    #[On('sub-discount-modal')]
    public function showSubDiscountModal($invoice)
    {
        if (Auth::user()->can('invoice payment') || Auth::user()->hasRole('admin')) {
            $invoice = Invoice::findOrFail($invoice);
            $this->invoice = $invoice;
            $this->subDiscountModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }


    public function sub_discount(AddDiscountRequest $request, InvoiceAction $invoiceAction)
    {
        $totalSpecialDiscount = $this->invoice->discount;
        $request->validate($this->input, $totalSpecialDiscount);
        $addDiscount = $invoiceAction->sub_discount(
            $this->invoice,
            $this->input['discount']
        );

        $this->subDiscountModal = false;
        $this->dispatch('refresh-billing-paket');
        if ($addDiscount['success']) {
            $this->success_notification('Success', 'Change discount successfully');
        } else {
            $this->error_notification('Failed', 'Change discount failed');
        }
    }

    public function render()
    {
        return view('livewire.admin.billings.modal.sub-discount');
    }
}
