<?php

namespace App\Livewire\Admin\Billings\Payments;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Carbon;
use Livewire\Attributes\Title;
use App\Models\Billings\PaymentHistory;

class PaymentManagement extends Component
{
    use WithPagination;
    #[Title('Payment Histories')]

    public $perPage = 25;
    public $sortField = 'full_name';
    public $sortDirection = 'asc';
    protected $queryString = ['sortField', 'sortDirection'];


    public $search_with_month = "";
    public $search_with_year = "";
    public $search_with_teller;

    public $startDateDeadline;
    public $endDateDeadline;

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection == 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection = 'asc';
        }
        $this->sortField = $field;
    }

    public function clearSearch()
    {
        $this->startDateDeadline = null;
        $this->endDateDeadline = null;
        $this->search_with_year = "";
        $this->search_with_month = "";
        $this->search_with_teller = null;
    }

    public function clearSearchWithYear()
    {
        $this->search_with_year = "";
    }
    public function clearSearchWithMonth()
    {
        $this->search_with_month = "";
    }

    public function clearSearchWithTeller()
    {
        $this->search_with_teller = null;
    }

    public function clearSearchDateDeadline()
    {
        $this->startDateDeadline = null;
        $this->endDateDeadline = null;
    }
    public function mount()
    {
        $this->search_with_month = Carbon::now()->format('m');
        $this->search_with_year = Carbon::now()->format('Y');
    }

    public function getPaymentHistories()
    {
        return PaymentHistory::query()
            ->when($this->search_with_teller, function ($builder) {
                // $this->resetPage();
                $builder->where('teller_name', $this->search_with_teller);
            })
            ->when($this->search_with_month, function ($builder) {
                $builder->whereMonth('created_at', $this->search_with_month);
            })
            ->when($this->search_with_year, function ($builder) {
                $builder->whereYear('created_at', $this->search_with_year);
            })
            ->when($this->startDateDeadline, function ($builder) {
                $this->search_with_month = "";
                $this->search_with_year = "";
                if ($this->startDateDeadline && $this->endDateDeadline) {
                    $builder->whereBetween('created_at', [Carbon::parse($this->startDateDeadline)->startOfDay(), Carbon::parse($this->endDateDeadline)->endOfDay()]);
                } else {
                    $builder->whereBetween('created_at', [Carbon::parse($this->startDateDeadline)->startOfDay(), Carbon::now()->endOfDay()]);
                }
            })
            ->orderByDesc('created_at')
            ->paginate($this->perPage);
    }

    public function render()
    {
        $paymentHistories = $this->getPaymentHistories();
        return view('livewire.admin.billings.payments.payment-management', compact('paymentHistories'));
    }
}
