<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Validation\Rule;
use App\Traits\StandardPhoneNumber;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class AddPhoneNumber extends Component
{
    use StandardPhoneNumber, NotificationTrait;
    public $addPhoneNumberModal = false;
    public $user;
    public $input = [];
    public $updateInstallationPhoneNumber = false;
    public $updateBillingPhoneNumber = false;

    #[On('add-phone-number-modal')]
    public function showAddPhoneNumberModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->addPhoneNumberModal = true;
            $this->user = $user;
            $this->input['phone'] = $this->localPhoneNumberFormat($user->user_address->phone);
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function closeModal()
    {
        $this->addPhoneNumberModal = false;
        $this->dispatch('refresh-customer-list');
    }

    public function editPhoneNumber()
    {
        $this->input['phone'] ?? $this->input['phone'] = null;
        if ($this->input['phone']) $this->input['phone'] = $this->internationalPhoneNumberFormat($this->input['phone']);
        Validator::make($this->input, [
            'phone' => ['nullable', 'regex:/^([0-9\s\+\(\)]*)$/', 'min:9', 'max:14', Rule::unique('user_addresses')->ignore($this->user->user_address->id, 'id')],
        ])->validate();

        $this->user->user_address->forceFill(['phone' => $this->input['phone']])->save();

        foreach ($this->user->customer_pakets as $customer_paket) {

            if ($this->updateInstallationPhoneNumber) {
                Validator::make($this->input, [
                    'phone' => ['nullable', 'regex:/^([0-9\s\+\(\)]*)$/', 'min:9', 'max:14', Rule::unique('customer_paket_addresses')->ignore($customer_paket->id, 'customer_paket_id')],
                ])->validate();

                $customer_paket->customer_installation_address->forceFill([
                    'phone' => $this->input['phone']
                ])->save();
            }

            if ($this->updateBillingPhoneNumber) {
                Validator::make($this->input, [
                    'phone' => ['nullable', 'regex:/^([0-9\s\+\(\)]*)$/', 'min:9', 'max:14', Rule::unique('customer_paket_addresses')->ignore($customer_paket->id, 'customer_paket_id')],
                ])->validate();
                $customer_paket->customer_billing_address->forceFill(['phone' => $this->input['phone']])->save();
            }
        }
        $this->closeModal();
    }


    public function render()
    {
        return view('livewire.admin.customers.modal.add-phone-number');
    }
}
