<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use App\Models\Address;
use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use App\Livewire\Actions\Users\UserAddressAction;
use App\Http\Requests\Customers\BulkUpdateCustomerAddressRequest;

class BulkEditCustomerModal extends Component
{
    use NotificationTrait;
    public $bulkEditCustomerModal = false;
    public $users;
    public $input = [];
    public $changeInstallationAddress = false;
    public $changeBillingAddress = false;
    public $country, $province, $city, $district, $subdistrict;

    #[On('bulk-edit-customer-modal')]
    public function showBulkEditCustomerModal($userSelected)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->bulkEditCustomerModal = true;
            $users = User::query()
                ->whereIn('id', $userSelected)
                ->get();
            $this->users = $users;
            $userSelected = [];
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
    }
    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }

    public function updateBulkCustomerInformation()
    {
        $this->resetErrorBag();
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? ''
        ]);
        (new BulkUpdateCustomerAddressRequest())->validate($this->input);

        $successUpdate = 0;
        $failedUpdate = 0;
        foreach ($this->users as $user) {
            try {
                (new UserAddressAction())->updateUserAddress($user, $this->input, $this->changeInstallationAddress, $this->changeBillingAddress);
                $successUpdate++;
            } catch (\Exception $e) {
                $failedUpdate++;
            }
        }

        $this->success_notification('Success', trans('customer.alert.bulk-edit-customer-detail', ['countSuccess' => $successUpdate, 'countFailed' => $failedUpdate]));
        $this->closeModal();
    }

    public function closeModal()
    {
        $this->bulkEditCustomerModal = false;
        $this->dispatch('refresh-customer-list');
        $this->dispatch('refresh-selected-users');
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.bulk-edit-customer-modal');
    }
}
