<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;
use App\Services\Billings\BillingService;

class CreateInvoice extends Component
{
    use WebSystemTrait, NotificationTrait;
    public $customerPakets;
    public $createInvoiceModal = false;
    public $input = [];

    #[On('create-invoice-modal')]
    public function showCreateInvoiceModal(User $user)
    {
        if (Auth::user()->can('invoice action') || Auth::user()->hasRole('admin')) {
            $this->customerPakets = $user->customer_pakets()->where('status', 'active')->get();
            $this->createInvoiceModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }


    public function createInvoice(BillingService $billingService)
    {
        $customerPaket = CustomerPaket::find($this->input['selectedPaket']);
        if ($customerPaket) {
            $mikrotikAutoIsolir = $customerPaket->mikrotik->auto_isolir;
            if ($mikrotikAutoIsolir->activation_date) {
                if ($this->isPrabayar()) {
                    $startInvoicePeriod = Carbon::parse(is_null($customerPaket->expired_date) ? Carbon::now() : $customerPaket->expired_date);
                } else {
                    $startInvoicePeriod = Carbon::parse($customerPaket->start_date);
                }
            } else {
                if ($this->isPrabayar()) {
                    $startInvoicePeriod = Carbon::parse(is_null($customerPaket->expired_date) ? Carbon::now()->setDay((int)$mikrotikAutoIsolir->due_date) : $customerPaket->expired_date);
                } else {
                    $startInvoicePeriod = Carbon::parse(is_null($customerPaket->start_date) ? Carbon::now()->setDay((int)$mikrotikAutoIsolir->due_date) : $customerPaket->start_date);
                }
            }
            $invoicePeriod = Carbon::parse($startInvoicePeriod)->startOfMonth()->format('Y-m-d');
            $invoice = $customerPaket->invoices()->where('periode', $invoicePeriod)->first();
            if (!$invoice) {
                $billingService->generateInvoice($customerPaket);
                $customerPaket->forceFill([
                    'paylater_date' => null
                ])->save();
            }
        }
        $this->dispatch('refresh-billing-paket');
        $this->closeModal();
    }

    public function closeModal()
    {
        $this->createInvoiceModal = false;
    }
    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.create-invoice');
    }
}
