<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use App\Models\Billings\Invoice;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;
use App\Services\Billings\BillingService;
use App\Services\Billings\ExportInvoiceService;
use App\Traits\NotificationTrait;

class CreateInvoiceFile extends Component
{
    use WebSystemTrait, NotificationTrait;
    public $customerPakets;
    //public $user;
    public $createInvoiceFileModal = false;
    public $input = [];
    public $fileExist = false;
    public $invoicesFile;
    public $invoices;

    #[On('create-invoice-file-modal')]
    public function showCreateInvoiceModal(User $user)
    {
        if (Auth::user()->can('invoice action') || Auth::user()->hasRole('admin')) {
            $this->customerPakets = $user->customer_pakets()->where('status', 'active')->get();
            $this->createInvoiceFileModal = true;
            $this->input['selectedPaket'] = '';
            $customerPaketsId = $this->customerPakets->pluck('id');
            $this->invoices = Invoice::where('status', '!=', 'paid')->whereIn('customer_paket_id', $customerPaketsId)->get();
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }


    public function exportInvoices(ExportInvoiceService $exportInvoiceService)
    {
        $customerPakets = CustomerPaket::whereId($this->input['selectedPaket'])->get();
        if ($customerPakets->count()) {
            $this->invoicesFile = $exportInvoiceService->create_invoices_file($customerPakets);
        } else {
            $this->invoicesFile = $exportInvoiceService->create_invoices_file($this->customerPakets);
        }
        $this->fileExist = $exportInvoiceService->ceckFile($this->invoicesFile, 'bulk_invoice_files');
    }

    public function download_invoices(ExportInvoiceService $exportInvoiceService)
    {
        $response = $exportInvoiceService->download_file($this->invoicesFile, 'bulk_invoice_files');
        if (!$response) {
            $this->error_notification('Failed!', 'Invoice file not found.');
        } else {
            $this->closeModal();
            return $response;
        }
    }

    public function closeModal()
    {
        $this->createInvoiceFileModal = false;
    }

    public function updatedInputSelectedPaket($value)
    {
        //$this->invoices = $this->get_users_billing();
        if ($value) {
            $customerPaket = CustomerPaket::find($value);
            $this->invoices = $customerPaket->unpayment_invoices;
        } else {
            $customerPaketsId = $this->customerPakets->pluck('id');
            $this->invoices = Invoice::where('status', '!=', 'paid')->whereIn('customer_paket_id', $customerPaketsId)->get();
        }
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.create-invoice-file');
    }
}
