<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;


use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPppPaket;
use App\Http\Requests\Customers\EditPppPaketRequest;

class EditCustomerPppPaketModal extends Component
{
    use NotificationTrait;
    public $editCustomerPppPaketModal = false;
    public $input = [];
    public $customerPppPaket;

    private CustomerPaketService $customerPaketService;
    public function boot(CustomerPaketService $customerPaketService)
    {
        $this->customerPaketService = $customerPaketService;
    }


    #[On('edit-customer-ppp-paket-modal')]
    public function showPppPaketModal(CustomerPppPaket $customerPppPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->editCustomerPppPaketModal = true;
            $this->input = array_merge([
                'username' => $customerPppPaket->username,
            ],  $customerPppPaket->withoutRelations()->toArray());
            $this->input['selectedPppService'] = $customerPppPaket->ppp_type_id;
            $this->customerPppPaket = $customerPppPaket;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function editPppPaket(EditPppPaketRequest $request)
    {
        $this->resetErrorBag();
        $request->validate(
            $this->input,
            $this->customerPppPaket
        );

        if ($this->customerPppPaket->customer_paket->status === 'pending') {
            $this->customerPppPaket->forceFill([
                'ppp_type_id' => $this->input['selectedPppService'],
                'username' => $this->input['username'],
                'password_ppp' => $this->input['password_ppp'],
            ])->save();
            $this->closeModal();
            $this->success_notification('Success', 'Update pppoe successfully.');
        } else {
            //update customer paket on mikrotik
            $res = $this->customerPaketService->update_ppp_paket(
                $this->customerPppPaket,
                $this->input
            );
            if ($res['success']) {
                $this->success_notification(trans('customer.alert.edit-customer-paket', ['customer' =>  $this->customerPppPaket->customer_paket->user->full_name]), trans('customer.alert.edit-customer-paket-successfully', ['customer' => $this->customerPppPaket->customer_paket->user->full_name, 'paket' =>   $this->customerPppPaket->customer_paket->paket->name]));
                $this->closeModal();
            } else {
                $this->error_notification(trans('customer.alert.edit-customer-paket', ['customer' =>  $this->customerPppPaket->customer_paket->user->full_name]), $res['message']);
            }
        }
    }

    /*
    public function notification($title, $message, $status)
    {
        LivewireAlert::title($title)
        ->text($message)
        ->position('top-end')
        ->toast()
        ->status($status)
        ->show();
    }
        */
    public function closeModal()
    {
        $this->dispatch('refresh-customer-list');
        $this->editCustomerPppPaketModal = false;
        $this->reset();
    }



    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.edit-customer-ppp-paket-modal');
    }
}
