<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;

class EditDiscount extends Component
{
    use NotificationTrait;
    public $editDiscountCustomerPaketModal = false;
    public $customerPaket;
    public $input = [];

    #[On('edit-discount-customer-paket-modal')]
    public function showEditDiscountCustomerPaketModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->editDiscountCustomerPaketModal = true;
            $this->customerPaket = $customerPaket;
            $this->input['discount'] = $customerPaket->discount;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function edit_discount_paket()
    {
        $this->customerPaket->forceFill(['discount' => $this->input['discount']])->save();
        $this->dispatch('refresh-customer-paket-list');
        $this->editDiscountCustomerPaketModal = false;
        $this->success_notification('Success', trans('Updated discount successfully.'));
    }
    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.edit-discount');
    }
}
