<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;
use Illuminate\Support\Facades\Validator;

class EditStartDate extends Component
{
    use NotificationTrait, WebSystemTrait;
    public $customerPaket, $dates, $expiredDate, $nextBilledAt;
    public $input = [];
    public $editStartDateModal = false;

    #[On('edit-start-date-modal')]
    public function showEditActivationCustomerPaketModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->editStartDateModal = true;
            $this->customerPaket = $customerPaket;
            $this->input['start_date'] = Carbon::parse($customerPaket->start_date)->format('Y-m-d');
            $this->expiredDate = Carbon::parse($this->input['start_date'])->add($this->customerPaket->getRenewalPeriod());
            $this->nextBilledAt = Carbon::parse($this->expiredDate)->subDays((int)$this->different_day_create_billing());
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function updatedInputStartDate($value)
    {
        $this->expiredDate = Carbon::parse($value)->add($this->customerPaket->getRenewalPeriod());
        $this->nextBilledAt = Carbon::parse($this->expiredDate)->subDays((int)$this->different_day_create_billing());
    }

    public function edit_start_date(CustomerPaketService $customerPaketService)
    {
        Validator::make($this->input, [
            'start_date' => ['required'],
        ])->validate();

        DB::beginTransaction();
        try {
            $customerPaketService->editActivationDate(
                $this->customerPaket,
                $this->input['activation_date'] ?? null,
                $this->input['start_date'],
                $this->expiredDate,
                $this->nextBilledAt
            );
            DB::commit();

            $this->editStartDateModal = false;
            $this->dispatch('refresh-customer-paket-list');
            $this->success_notification('Success', 'Update start date successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error_notification('Failed', $e->getMessage());
        }
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.edit-start-date');
    }
}
