<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPppPaket;

class ShowCustomerPppPaket extends Component
{
    use NotificationTrait;
    public $showCustomerPppPaketModal = false;
    public $usernamePpp;
    public $passwordPpp;

    #[On('show-customer-ppp-paket-modal')]
    public function showCustomerPppPaketModal(CustomerPppPaket $customerPppPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->showCustomerPppPaketModal = true;
            $this->usernamePpp = $customerPppPaket->username;
            $this->passwordPpp = $customerPppPaket->password_ppp;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }
    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.show-customer-ppp-paket');
    }
}
