<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use App\Models\UserAddress;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\CurrentPasswordRequest;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;

class DisableWaNotification extends Component
{
    use NotificationTrait;
    public $disableWaNotificationModal = false;
    public $input = [];
    public $userAddress;

    #[On('disable-wa-notification-modal')]
    public function showDisableWaNotificationModal(UserAddress $userAddress)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->disableWaNotificationModal = true;
            $this->userAddress = $userAddress;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function disableWaNotification(CurrentPasswordRequest $currentPasswordRequest)
    {
        $currentPasswordRequest->validate($this->input);
        $this->userAddress->forceFill([
            'wa_notification' => $this->userAddress->wa_notification ? false : true
        ])->save();
        $this->dispatch('refresh-customer-list');
        LivewireAlert::title(trans('user.alert.success'))
            ->text(trans('user.alert.update-wa-notification-successfully'))
            ->position('top-end')
            ->toast()
            ->status('success')
            ->show();

        $this->disableWaNotificationModal = false;
    }


    public function render()
    {
        return view('livewire.admin.customers.modal.disable-wa-notification');
    }
}
