<?php

namespace App\Livewire\Admin\Customers;

use App\Models\User;
use Livewire\Component;
use Illuminate\Support\Str;
use App\Models\Billings\Invoice;
use App\Services\Billings\ExportInvoiceService;
use Livewire\Attributes\On;

class ShowBillingCustomer extends Component
{
    public $user;
    public function mount(User $user)
    {
        $this->user = $user;

    }

    public function download_customer_invoice(Invoice $invoice, ExportInvoiceService $exportInvoiceService)
    {
        $response = $exportInvoiceService->download_invoice_file($invoice, 'invoice_files');
        if ($response) {
            return $response;
        }
    }

    #[On('refresh-customer-list')]
    #[On('refresh-billing-paket')]
    public function render()
    {
        return view('livewire.admin.customers.show-billing-customer');
    }
}
