<?php

namespace App\Livewire\Admin\Mikrotiks\Modal;

use Livewire\Component;
use App\Models\Websystem;
use Livewire\Attributes\On;
use App\Services\PaketService;
use App\Models\Servers\Mikrotik;
use App\Services\CustomerService;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Support\CollectionPagination;
use Illuminate\Support\Facades\Validator;
use App\Services\Mikrotiks\MikrotikService;


class ExportCustomerModal extends Component
{
    use NotificationTrait;
    public $exportCustomerModal = false;
    public $input = [];
    public $mikrotiks;
    public $fromMikrotik;
    private PaketService $paketService;
    private CustomerService $customerService;
    private MikrotikService $mikrotikService;
    public $maxSecret = 0;
    public $countDifferentUserSecret = 0;
    public $toMikrotik;

    public function __construct()
    {
        if (Auth::user()->can('mikrotik action') || Auth::user()->hasRole('admin')) {
            $this->mikrotikService = new MikrotikService;
            $this->customerService = new CustomerService();
            $this->paketService = new PaketService();
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    #[On('show-export-customer-modal')]
    public function showExportCustomerModal(Mikrotik $mikrotik)
    {
        $this->reset();
        $this->exportCustomerModal  = true;
        $this->fromMikrotik = $mikrotik;
        $this->mikrotiks = Mikrotik::whereDisabled('false')->orderBy('name')->get();
    }

    public function updatedInputSelectedServer($mikrotikId)
    {
        $this->toMikrotik = Mikrotik::find($mikrotikId);

        if ($this->toMikrotik) {
            $neededExportCustomers = $this->customerService->neededExportCustomers($this->fromMikrotik, $this->toMikrotik);
            $this->countDifferentUserSecret = count($neededExportCustomers);

            if (env('QUEUE_CONNECTION') == 'sync') {
                $neededExportCustomers =   (new CollectionPagination($neededExportCustomers))->collectionPaginate(Websystem::first()->max_process);
            }
            $this->maxSecret = count($neededExportCustomers);
        } else {
            $this->countDifferentUserSecret = 0;
            $this->maxSecret = 0;
        }
    }

    public function exportCustomer()
    {
        Validator::make($this->input, [
            'selectedServer' => ['required'],
        ])->validate();

        try {
            $this->customerService->exportCustomersToMikrotik($this->fromMikrotik, $this->toMikrotik);
            $message = trans('customer.alert.export-customer-in-progress', ['mikrotik' => $this->toMikrotik->name]);
            $this->notification(trans('customer.alert.export-customer'), $message, 'success');
        } catch (\Exception $e) {
            $this->notification('Failed', $e->getMessage(), 'error');
        }
        $this->exportCustomerModal  = false;
    }

    public function render()
    {
        return view('livewire.admin.mikrotiks.modal.export-customer-modal');
    }
}
