<?php

namespace App\Livewire\Admin\Mikrotiks\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Carbon;
use App\Models\Servers\Mikrotik;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Services\ImportCustomerService;
use Illuminate\Support\Facades\Validator;

class ImportCustomerModal extends Component
{
    use NotificationTrait;
    public $importCustomerModal = false;
    public $input = [];
    public $mikrotik;
    private ImportCustomerService $importCustomerService;
    public $countDifferentUserSecret = 0;
    public $mikrotikOnline;

    public function __construct()
    {
        $this->importCustomerService = new ImportCustomerService;
    }

    #[On('show-import-customer-modal')]
    public function showImportCustomerModal(Mikrotik $mikrotik)
    {
        if (Auth::user()->can('mikrotik action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->importCustomerModal  = true;
            $this->input['activation_date'] = Carbon::now();
            $this->input['renewal_period'] = 'monthly';
            $this->input['use_comment_activation_date'] = false;
            $this->mikrotik = $mikrotik;
            try {
                $this->mikrotikOnline = true;
                $differentUserSecret = $this->importCustomerService->neededUserSecrets($mikrotik);
                $this->countDifferentUserSecret = count($differentUserSecret);
            } catch (\Exception $e) {
                $this->mikrotikOnline = false;
            }
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function importCustomer()
    {
        Validator::make($this->input, [
            'email_domain' => ['required'],
        ])->validate();

        try {
            $importCustomerStatus = $this->importCustomerService->importCustomersFromMikrotik($this->mikrotik, $this->input);
            if ($importCustomerStatus['success']) {
                $status = 'success';
                $message = trans('mikrotik.alert.import-customers-in-progress', ['countCustomer' => $this->countDifferentUserSecret]);
            } else {
                $status = 'error';
                $message = $importCustomerStatus['message'];
            }

            $this->notification(trans('mikrotik.alert.import-customers'), $message, $status);
            $this->importCustomerModal  = false;
        } catch (\Exception $e) {
            $this->notification('Failed', $e->getMessage(), 'error');
        }
    }

    public function render()
    {
        return view('livewire.admin.mikrotiks.modal.import-customer-modal');
    }
}
