<?php

namespace App\Livewire\Admin\Mikrotiks\Modal;

use Livewire\Component;
use App\Models\Websystem;
use Livewire\Attributes\On;
use App\Services\PaketService;
use App\Models\Servers\Mikrotik;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Services\Mikrotiks\MikrotikService;

class ImportPaketModal extends Component
{
    use NotificationTrait;
    public $importPaketModal = false;
    public $input = [];
    public $mikrotik;
    public $maxProfile = 0;
    public $countDifferentProfile = 0;
    private MikrotikService $mikrotikService;
    private PaketService $paketService;

    public function __construct()
    {
        $this->mikrotikService = new MikrotikService;
        $this->paketService = new PaketService;
    }

    #[On('show-import-paket-modal')]
    public function showImportCustomerModal(Mikrotik $mikrotik)
    {
        if (Auth::user()->can('mikrotik action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->importPaketModal = true;
            $this->mikrotik = $mikrotik;
            try {
                $differentProfilesName = $this->paketService->neededCreateProfiles($this->mikrotik);
                $maxProcess = Websystem::first()->max_process;
                env('QUEUE_CONNECTION') == 'sync' ? (count($differentProfilesName) > $maxProcess ? $this->maxProfile = $maxProcess : $this->maxProfile = count($differentProfilesName)) : $this->maxProfile = count($differentProfilesName);
                $this->countDifferentProfile = count($differentProfilesName);
            } catch (\Exception $e) {
                $this->notification('Failed', $e->getMessage(), 'error');
            }
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function importPaket()
    {
        try {
            $this->paketService->importPaketsFromMikrotik($this->mikrotik);
            $message = trans('mikrotik.alert.import-profiles-in-progress', ['countProfile' => $this->maxProfile, 'mikrotik' => $this->mikrotik->name]);
            $this->notification(trans('mikrotik.alert.import-profiles'), $message, 'success');
            $this->importPaketModal = false;
        } catch (\Exception $e) {
            $this->notification('Failed', $e->getMessage(), 'error');
            $this->importPaketModal = false;
        }
    }

    public function render()
    {
        return view('livewire.admin.mikrotiks.modal.import-paket-modal');
    }
}
