<?php

namespace App\Livewire\Admin\Mikrotiks\View;

use GuzzleHttp\Client;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Servers\Mikrotik;
use App\Services\CustomerService;
use App\Services\ImportCustomerService;
use App\Support\CollectionPagination;
use Illuminate\Support\Facades\Cache;

use App\Services\Mikrotiks\MikrotikService;
use App\Services\Mikrotiks\MikrotikPppService;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;
//use App\Services\Mikrotiks\MikrotikPppUserSecretService;

class MikrotikUserSecrets extends Component
{
    use WithPagination;

    public Mikrotik $mikrotik;
    public  $perPage = 20;
    public $online;
    public $countUserSecretNonCustomer = 0;
    public $countProfileNonPaket = 0;
    //public $userSecrets;

    public $searchByImported;

    private MikrotikService $mikrotikService;
    private MikrotikPppService $mikrotikPppService;
    //private MikrotikPppUserSecretService $mikrotikPppUserSecretService;
   // private customerService $customerService;
   private ImportCustomerService $importCustomerService;


    public function __construct()
    {
        $this->mikrotikService = new MikrotikService;
        $this->mikrotikPppService = new MikrotikPppService;
        //$this->mikrotikPppUserSecretService = new MikrotikPppUserSecretService;
        $this->importCustomerService = new ImportCustomerService;
    }

    public function mount(Mikrotik $mikrotik)
    {
        // dd($this->searchByImported);
        $this->mikrotik = $mikrotik;
    }

    public function updatedSearchByImported($value) {}

    public function render()
    {
        $userSecrets = collect([]);
        try {
            $userSecrets = $this->mikrotikService->getAllUserSecrets($this->mikrotik);
            if ($this->searchByImported == 'imported') {
                $userSecrets = $this->importCustomerService->neededUserSecrets($this->mikrotik, true);
            } else if ($this->searchByImported == 'not-imported') {
                $userSecrets = $this->importCustomerService->neededUserSecrets($this->mikrotik);
            }
            $this->online = true;
        } catch (\Exception $e) {
            $this->online = false;
            /*  LivewireAlert::title('Failed')
                ->text($e->getMessage())
                ->position('center')
                // ->toast()
                ->status('error')
                ->show();*/
            $this->redirect(route('managements.mikrotik.dashboard', ['mikrotik' => $this->mikrotik->slug]), navigate: true);
        }

        $secrets = (new CollectionPagination($userSecrets))->collectionPaginate($this->perPage);
        return view('livewire.admin.mikrotiks.view.mikrotik-user-secrets', compact('secrets'))->title($this->mikrotik->version ??'');
    }
}
