<?php

namespace App\Livewire\Admin\Pakets\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use App\Models\Pakets\PaketProfile;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Paket\AddPaketProfileRequest;
use App\Livewire\Actions\Pakets\PaketProfileAction;
use App\Http\Requests\Paket\EditPaketProfileRequest;

class AddPaketProfileModal extends Component
{
    use NotificationTrait;
    public $addPaketProfileModal = false;
    public $paketProfileSelect;
    public $input = [];

    #[On('show-add-paket-profile-modal')]
    public function showAddPaketProfileModal(PaketProfile $paketProfile)
    {
        if (Auth::user()->can('paket action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->addPaketProfileModal = true;

            if ($paketProfile->exists) {
                $rate_limit = explode(' ', $paketProfile->rate_limit);
                $this->paketProfileSelect = $paketProfile;
                if (count($rate_limit) == 6) {
                    $this->input = array_merge([
                        'profile_name' => $paketProfile->profile_name,
                        'max_limit' => $rate_limit[0],
                        'burst_limit' => $rate_limit[1],
                        'burst_threshold' => $rate_limit[2],
                        'burst_time' => $rate_limit[3],
                        'priority' => $rate_limit[4],
                        'limit_at' => $rate_limit[5],
                    ], $paketProfile->withoutRelations()->toArray());
                } else {
                    $this->input = array_merge([
                        'profile_name' => $paketProfile->profile_name,
                    ], $paketProfile->withoutRelations()->toArray());
                }
            } else {
                $this->paketProfileSelect = new PaketProfile();
            }
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function addPaketProfile(AddPaketProfileRequest $request)
    {
        $request->validate($this->input);
        $profile = (new PaketProfileAction())->add_profile($this->input);
        $this->success_notification(trans('paket.alert.success'), trans('paket.alert.add-profile-paket-successfully', ['profile' => $profile->profile_name]));

        $this->closeAddPaketProfileModal();
    }

    public function updatePaketProfile(EditPaketProfileRequest $request)
    {
        $request->validate($this->paketProfileSelect, $this->input);
        $profile = (new PaketProfileAction())->update_profile($this->paketProfileSelect, $this->input);
        if ($profile['status'] == 'success') {
            $this->success_notification(trans('paket.alert.success'), trans('paket.alert.update-profile-paket-successfully', ['profile' => $this->paketProfileSelect->profile_name]));
            $this->closeAddPaketProfileModal();
        } else {
            $this->error_notification(trans('paket.alert.failed'), $profile['message']);
        }
    }

    public function closeAddPaketProfileModal()
    {
        $this->dispatch('refresh-paket-profile');
        $this->addPaketProfileModal = false;
    }
    public function render()
    {
        return view('livewire.admin.pakets.modal.add-paket-profile-modal');
    }
}
