<?php

namespace App\Livewire\Admin\Roles\Modal;

use App\Models\User;
use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use App\Services\Roles\RoleFormFields;
use Spatie\Permission\Models\Permission;

class EditRole extends Component
{
    use NotificationTrait;
    public $editRoleModal = false;
    public $permissions;
    public $role;
    public $form = [];
    public $selectAll;


    #[On('show-edit-role-modal')]
    public function showEditRoleModal(Role $role)
    {
        if (Auth::user()->can('role action') || Auth::user()->hasRole('admin')) {
            $this->editRoleModal = true;
            $this->permissions = Permission::all();
            $this->role = $role;

            $service = new RoleFormFields($role->id);
            $data = $service->handle();
            $this->form = collect($this->permissions->whereIn('id', $data['rolePermissionsIds']))->pluck('name')->toArray();
            $this->dispatch('selectGroup', $this->form);
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }



    public function save()
    {
        $this->role->syncPermissions($this->form);
        //Update user permission
        $users = User::role($this->role->name)->get();
        $permissions = $this->role->permissions;
        foreach ($users as $user) {
            $user->syncPermissions($permissions);
        }
        $this->editRoleModal = false;
        $this->success_notification('Success', 'Update role successfully.');
        $this->dispatch('refresh-role-and-permission-list');
    }

    public function updatedSelectAll($value)
    {
        if ($value) {
            // Select all options
            $this->form = collect($this->permissions)->pluck('name')->toArray();
        } else {
            // Clear selection
            $this->form = [];
        }
        // Dispatch an event to update Choices.js
        $this->dispatch('selectGroup', $this->form);
    }
    public function render()
    {
        return view('livewire.admin.roles.modal.edit-role');
    }
}
