<?php

namespace App\Livewire\Admin\Settings\Address\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Jobs\ImportAddressJob;
use App\Traits\NotificationTrait;
use Illuminate\Console\Command;

class ImportAddress extends Component
{
    use NotificationTrait;
    public $importAddressModal;
    public $addresses = [];

    #[On('import-address-modal')]
    public function show_import_address_modal()
    {
        $this->importAddressModal = true;
        /* $this->addresses = $this->getAddress('https://alamat.thecloudalert.com/api/provinsi/get/');
        if ($this->addresses['status'] === 200) {
            $this->addresses = $this->addresses['result'];
        } else {
            $this->addresses = collect();
        }
            */
    }

    public function importAddress()
    {
        /*
        $province = collect($this->addresses)->where('id', $provinceId)->first();
        //dd($provinceId.' '. $province['text']);
        $country = Address::whereName('Indonesia')->first();
        if ($country) {
            $newProvince = Address::create([
                'name' => $province['text'],
                'address_id' =>  $country->id,
                'description' => 'province'
            ]);
            //sleep(5);
            try {
                $cities = collect($this->getAddress('https://alamat.thecloudalert.com/api/kabkota/get/?d_provinsi_id=' . $provinceId));
            } catch (\Exception $e) {
                Log::info('Error import city from ' . $province['text'] . ' Message: ' . $e->getMessage());
                $cities = collect();
            }
            if ($cities->count()) {
                foreach ($cities['result'] as $city) {
                    $newCity = Address::create([
                        'name' => $city['text'],
                        'address_id' => $newProvince->id,
                        'description' => 'city'
                    ]);
                    // sleep(5);
                    try {
                        $districts = collect($this->getAddress('https://alamat.thecloudalert.com/api/kecamatan/get/?d_kabkota_id=' . $city['id']));
                    } catch (\Exception $e) {
                        Log::info('Error import district ' . $city['id'] . ' Message: ' . $e->getMessage());
                        $districts = collect();
                    }
                    if ($districts->count()) {
                        foreach ($districts['result'] as $district) {
                            $newDistrict = Address::create([
                                'name' => $district['text'],
                                'address_id' => $newCity->id,
                                'description' => 'district'
                            ]);
                            //  sleep(5);
                            try {
                                $subDistricts = collect($this->getAddress('https://alamat.thecloudalert.com/api/kelurahan/get/?d_kecamatan_id=' . $district['id']));
                            } catch (\Exception $e) {
                                Log::info('Error import subdistrict ' . $district['id'] . ' Message: ' . $e->getMessage());
                                $subDistricts = collect();
                            }
                            if ($subDistricts->count()) {
                                foreach ($subDistricts['result'] as $subDistrict) {
                                    Address::create([
                                        'name' => $subDistrict['text'],
                                        'address_id' => $newDistrict->id,
                                        'description' => 'subdistrict'
                                    ]);
                                }
                            }
                        }
                    }
                }
            }
        }
        */
        if (cache()->get('processing_import_address')) {
            $this->warn('Processing import address is already running');
            return Command::FAILURE;
        }
        cache()->put('processing_import_address', true, 60); // Lock for 60 minutes
        try {

            dispatch(new ImportAddressJob())->onQueue('default');
            return Command::SUCCESS;
        } catch (\Exception $e) {
            cache()->forget('processing_import_address');
            $this->error("Error processing import address: " . $e->getMessage());
            return Command::FAILURE;
        }


        $this->notification('Success', 'Import address successfully.', 'success');
        $this->importAddressModal = false;
        $this->dispatch('refresh-address-list');
    }

    public function render()
    {
        return view('livewire.admin.settings.address.modal.import-address');
    }
}
