<?php

namespace App\Livewire\Admin\Settings\PaymentGateway;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\PaymentGateway;
use Illuminate\Support\Facades\Validator;

class TripayForm extends Component
{
    use NotificationTrait;
    public $input = [];
    public $enable;
    public $development;
    public $production;

    // private PaymentGateway $paymentGateway;

    public function mount()
    {
        // $tripay = PaymentGateway::whereValue('tripay')->first();
        $this->input = array_merge([
            'merchant_code' => env('TRIPAY_PRODUCTION_MERCHANT_ID'),
            'production_secret_key' => env('TRIPAY_PRODUCTION_PRIVATE_KEY'),
            'production_api_key' => env('TRIPAY_PRODUCTION_API_KEY'),

            'development_merchant_code' => env('TRIPAY_DEV_MERCHANT_ID'),
            'development_secret_key' => env('TRIPAY_DEV_PRIVATE_KEY'),
            'development_api_key' => env('TRIPAY_DEV_API_KEY'),
        ]);
        $this->production = env('TRIPAY_MODE') == 'production' ? true : false;
        $this->development = env('TRIPAY_MODE') == 'development' ? true : false;
    }

    public function updatedEnable($active)
    {
        if ($active) {
            PaymentGateway::whereValue('tripay')->first()->setActive();
            PaymentGateway::whereValue('midtrans')->first()->setNonActive();
        } else {
            PaymentGateway::whereValue('tripay')->first()->setNonActive();
        }
        $this->dispatch('update-status-payment-gateway')->to(MidtransForm::class);
    }

    public function updatedDevelopment($enable)
    {
        if ($enable) {
            setEnv('TRIPAY_MODE', 'development');
        } else {
            $validator = Validator::make($this->input, [
                'merchant_code' => ['required'],
                'production_api_key' => ['required'],
                'production_secret_key' => ['required'],
            ]);
            if ($validator->fails()) {
                $this->development = true;
                $validator->validate();
            }
            setEnv('TRIPAY_MODE', 'production');
        }
        $this->development ? $this->production = false : $this->production = true;
        $this->success_notification('Success', 'Tripay updated to Development.');
    }

    public function updatedProduction($enable)
    {
        if ($enable) {
            $validator = Validator::make($this->input, [
                'merchant_code' => ['required'],
                'production_api_key' => ['required'],
                'production_secret_key' => ['required'],
            ]);
            if ($validator->fails()) {
                $this->production = false;
                $validator->validate();
            }
            setEnv('TRIPAY_MODE', 'production');
            $this->development = false;
            $this->success_notification('Success', 'Tripay updated to Production.');
        } else {
            setEnv('TRIPAY_MODE', 'development');
        }
        $this->production ? $this->development = false : $this->development = true;
    }

    public function update_tripay()
    {
        Validator::make($this->input, [
            'development_merchant_code' => ['required'],
            'development_api_key' => ['required'],
            'development_secret_key' => ['required'],
        ])->validate();

        setEnv('TRIPAY_DEV_MERCHANT_ID', $this->input['development_merchant_code'] ?? '');
        setEnv('TRIPAY_DEV_PRIVATE_KEY', $this->input['development_secret_key'] ?? '');
        setEnv('TRIPAY_DEV_API_KEY', $this->input['development_api_key'] ?? '');
        setEnv('TRIPAY_PRODUCTION_MERCHANT_ID', $this->input['merchant_code'] ?? '');
        setEnv('TRIPAY_PRODUCTION_PRIVATE_KEY', $this->input['production_secret_key'] ?? '');
        setEnv('TRIPAY_PRODUCTION_API_KEY', $this->input['production_api_key'] ?? '');

        $this->success_notification(trans('websystem.alert.updated'), trans('websystem.alert.tripay-updated-successfully'));
    }

    #[On('update-status-payment-gateway')]
    public function render()
    {
        $tripay = PaymentGateway::whereValue('tripay')->first();
        $this->enable = $tripay->is_active ? true : false;
        return view('livewire.admin.settings.payment-gateway.tripay-form');
    }
}
