<?php

namespace App\Livewire\Admin\Users\Modal;

use App\Models\User;
use App\Models\Address;
use Livewire\Component;
use App\Models\UserAddress;
use Livewire\Attributes\On;
use Illuminate\Support\Carbon;
use App\Services\User\UserService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;
use App\Http\Requests\Customers\UpdateUserStepTwoRequest;
use App\Http\Requests\Customers\UpdateUserStepThreeRequest;
use App\Http\Requests\Customers\CreateCustomerStepOneRequest;

class EditUserModal extends Component
{
    public $editUserModal = false;
    public $userSelect;
    public $input = [];

    public $currentStep = 1;
    public $country, $province, $city, $district, $subdistrict;


    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
        $this->province = null;
        $this->city = null;
        $this->district = null;
        $this->subdistrict = null;
    }

    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }
    /**
     * Add or Edit User Modal
     */
    #[On('edit-user-modal')]
    public function showEditUserModal(User $user)
    {
        $this->resetErrorBag();
        $this->editUserModal = true;
        $this->input['first_name'] = $user->first_name;
        $this->input['last_name'] = $user->last_name;
        $this->input['gender'] = $user->user_admin->gender;
        $this->input['dob'] =  Carbon::parse($user->user_admin->dob)->format('Y-m-d');
        $this->userSelect = $user;
    }

    public function firstStepSubmit()
    {
        $this->resetErrorBag();
        (new CreateCustomerStepOneRequest())->validate($this->input);
        $this->currentStep = 2;
        $userAddress = $this->userSelect->user_address;
        if ($userAddress) {
            $this->country = Address::whereName($userAddress->country)->first();
            if ($this->country) {
                request()['country'] = $this->country->id;
                $this->province = Address::whereAddressId($this->country->id)->whereName($userAddress->province)->first();
                if ($this->province) {
                    request()['province'] = $this->province->id;
                    $this->city = Address::whereAddressId($this->province->id)->whereName($userAddress->city)->first();
                    if ($this->city) {
                        request()['city'] = $this->city->id;
                        $this->district = Address::whereAddressId($this->city->id)->whereName($userAddress->district)->first();
                        if ($this->district) {
                            request()['district'] = $this->district->id;
                            $this->subdistrict = Address::whereAddressId($this->district->id)->whereName($userAddress->subdistrict)->first();
                            if ($this->subdistrict) {
                                request()['subdistrict'] = $this->subdistrict->id;
                            }
                        }
                    }
                }
            }
            $this->input['address'] = $this->userSelect->user_address->address;
            $this->input['phone'] = $this->userSelect->user_address->phone;
        } else {
            $userAddress = new UserAddress();
        }
        $this->input['address'] = $this->userSelect->user_address->address;
        $this->input['phone'] = $this->userSelect->user_address->phone;
    }

    public function secondStepSubmit()
    {
        $this->resetErrorBag();
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? ''
        ]);
        (new UpdateUserStepTwoRequest())->validate($this->userSelect->user_address, $this->input);
        $this->input['email'] = $this->userSelect->email;
        $this->input['role'] = $this->userSelect->getRoleNames()->first();
        $this->currentStep = 3;
    }

    public function updateUserInformation()
    {
        (new UpdateUserStepThreeRequest())->validate($this->userSelect, $this->input);
        $userRoles = $this->userSelect->getRoleNames();
        $thisUserAdmin = false;
        foreach($userRoles as $userRole){
            if ($userRole === "admin"){
                $thisUserAdmin = true;
            }
        }

        $countAdminSafe = 1;
        $adminCount = User::with('roles')->get()->filter(
            fn($user) => $user->roles->where('name', 'admin')->toArray()
        )->count();

      //  $users = User::role('admin')->get();


        if ($adminCount <=  $countAdminSafe && $this->input['role'] != 'admin' && $thisUserAdmin) {
            $title = trans('user.alert.failed');
            $text = trans('user.alert.text-failed-change-admin', ['count' =>  $countAdminSafe]);
            $status = 'error';
        } else {
            DB::beginTransaction();
            (new UserService())->updateUserAdmin($this->userSelect, $this->input);
            DB::commit();
            $this->dispatch('refresh-user-list');
            $title = trans('user.alert.user-updated');
            $text = trans('user.alert.user-updated-successfully', ['user' => $this->userSelect->full_name]);
            $status = 'success';
        }
        $this->notification($title, $text, $status);
        $this->closeEditUserModal();
    }

    public function notification($title, $text, $status)
    {
        LivewireAlert::title($title)
            ->text($text)
            ->position('top-end')
            ->toast()
            ->status($status)
            ->show();
    }
    public function back($step)
    {
        $this->currentStep = $step;
    }

    /**
     * Close add user modal
     */
    #[On('close-edit-user-modal')]
    public function closeEditUserModal()
    {
        $this->dispatch('refresh-user-list');
        $this->currentStep = 0;
        $this->editUserModal = false;
        $this->reset();
    }


    public function render()
    {
        return view('livewire.admin.users.modal.edit-user-modal');
    }
}
