<?php

namespace App\Livewire\Admin\WhatsappGateway;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\WithPagination;
use App\Http\Controllers\API\WhatsappGateway;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Services\WhatsappGateway\GatewayApiService;
use App\Traits\NotificationTrait;


class Device extends Component
{
    use WithPagination, NotificationTrait;
    public function testSendMessage($number)
    {

        $data = [
            'sender' => $number,
            'number' => $number,
            'message' => 'Congrulation, whatsapp gateway successfully connected.'
        ];

        $response = (new GatewayApiService)->sendMessage(WhatsappGateway::SEND_MESSAGE, $data);

        if ($response['success']) {
            $this->success_notification('Success', $response['payload']['message']);
        } else {
            $this->error_notification('Failed', $response['message']);
        }

    }

    #[On('refresh-devices-list')]
    public function render()
    {
        $page = LengthAwarePaginator::resolveCurrentPage();
        $devices = [];
        $total = 1;
        $perPage = 10;

        try {
            $response = (new GatewayApiService())->getRequest(WhatsappGateway::DEVICES);
            //dd($response);
            if ($response['success']) {
                $data = $response['payload']['data'];
                $total =  $data['total'];
                $perPage = $data['per_page'];
                $devices = $data['devices'];
            } else {
                $this->error_notification('Error', $response['message'] ?? 'Unknow error, please contact administrator.');
            }
        } catch (\Exception $e) {
            $this->redirect(route('managements.whatsapp_gateway'), navigate: true);
        }

        $devices = new LengthAwarePaginator($devices, $total, $perPage, $page, [
            'path' => LengthAwarePaginator::resolveCurrentPath(),
        ]);
        return view('livewire.admin.whatsapp-gateway.device', compact('devices'));
    }
}
