<?php

namespace App\Livewire\Admin\WhatsappGateway;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Http\Controllers\API\WhatsappGateway;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Services\WhatsappGateway\GatewayApiService;

class InvoiceManagement extends Component
{
    use NotificationTrait;

    #[On('refresh-invoice-list')]
    public function render()
    {
        $page = LengthAwarePaginator::resolveCurrentPage();
        $perPage = 10;
        $total = 1;
        $invoices = [];

        try {
            $response = (new GatewayApiService())->getRequest(WhatsappGateway::INVOICE);

            if ($response['success']) {
                $data = $response['payload']['data'];
                $perPage = $data['per_page'];
                $total = $data['total'];
                $invoices = $data['invoices'];
            } else {
                $this->error_notification('Error', $response['message'] ?? 'Unknow error, please contact administrator.');
            }
        } catch (\Exception $e) {
            $this->redirect(route('managements.whatsapp_gateway'), navigate: true);
        }
        // $invoices = (new CollectionPagination($invoices))->collectionPaginate(20);
        $invoices = new LengthAwarePaginator($invoices, $total, $perPage, $page, [
            'path' => LengthAwarePaginator::resolveCurrentPath(),
        ]);


        return view('livewire.admin.whatsapp-gateway.invoice-management', compact('invoices'));
    }
}
