<?php

namespace App\Livewire\Admin\WhatsappGateway;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\WithPagination;
use App\Traits\NotificationTrait;
use App\Http\Controllers\API\WhatsappGateway;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Services\WhatsappGateway\GatewayApiService;

class MessageHistories extends Component
{
    use WithPagination, NotificationTrait;

    #[On('confirm-delete')]
    public function delete($id)
    {
        try {
            $response = (new GatewayApiService())->deleteRequest(WhatsappGateway::MESSAGE_HISTORIES, $id);

            if ($response['success']) {
                $this->success_notification('Success', $response['payload']['message'] ?? 'Delete history message succesfully.');
            } else {
                $this->error_notification('Failed', $response['message'] ?? 'Unknow error, please contact administrator.');
            }
        } catch (\Exception $e) {
            $this->error_notification('Failed', $e->getMessage());
        }
    }

    #[On('confirm-delete-all')]
    public function delete_all()
    {
        try {
            $response = (new GatewayApiService())->getRequest(WhatsappGateway::DELETE_ALL_MESSAGE_HISTORIES);

            if ($response['success']) {
                $this->success_notification('Success', $response['payload']['message'] ?? 'Delete history message succesfully.');
            } else {
                $this->error_notification('Failed', $response['message'] ?? 'Unknow error, please contact administrator.');
            }
        } catch (\Exception $e) {
            $this->error_notification('Failed', $e->getMessage());
        }
    }

    public function render()
    {
        $perPage = 1;
        $total = 10;
        $messageHistories = [];
        $page = LengthAwarePaginator::resolveCurrentPage();

        try {
            $response = (new GatewayApiService())->getRequest(WhatsappGateway::MESSAGE_HISTORIES);
            //dd($response);
            if ($response['success']) {
                $data = $response['payload']['data'];
                $perPage = $data['per_page'];
                $total = $data['total'];
                $messageHistories = $data['message_histories'];
            } else {
                $this->error_notification('Error', $response['message'] ?? 'Unknow error, please contact administrator.');
            }
        } catch (\Exception $e) {
            // $messageHistories = [];
            // $this->notification('Error', $e->getMessage(), 'error');
            $this->redirect(route('managements.whatsapp_gateway'), navigate: true);
        }
        $messageHistories = new LengthAwarePaginator($messageHistories, $total, $perPage, $page, [
            'path' => LengthAwarePaginator::resolveCurrentPath(),
        ]);
        return view('livewire.admin.whatsapp-gateway.message-histories', [
            'messageHistories' => $messageHistories
        ]);
    }
}
