<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use App\Http\Controllers\API\WhatsappGateway;
use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Validator;
use App\Services\WhatsappGateway\GatewayApiService;

class EditDevice extends Component
{
    use NotificationTrait;
    //use WhatsappGatewayTrait;

    private $url;

    //protected const ROUTE_DEVICE = 'api/devices';

    public $editDeviceModal = false;
    public $number;
    public $input = [];
    public $device;


    #[On('show-edit-device-modal')]
    public function editDeviceModal($number)
    {
        $this->reset();
        $response = (new GatewayApiService())->showRequest(WhatsappGateway::DEVICES, $number);
        // dd($response['result']['data']);
        if ($response['success']) {
            $device = $response['payload']['data']['device'];
            $this->editDeviceModal = true;
            $this->input = array_merge([
                'number' => $device['body'],
            ], $device);
            $this->device = $device;
        } else {
            $this->error_notification('Failed', $response['message']);
        }
    }

    public function updateNumber()
    {
        Validator::make(
            $this->input,
            [
                'device_name' => 'required',
                'description' => ['nullable', 'string', 'min:10', 'max:255'],
            ]
        )->validate();

        if ($this->device['description'] != $this->input['description'] || $this->device['device_name'] != $this->input['device_name']) {
            $response = (new GatewayApiService())->updateRequest(WhatsappGateway::DEVICES, $this->device['body'], $this->input);

            if ($response['success']) {
                $this->closeModal();
                $this->success_notification('Success', $response['payload']['message']);
            } else {
                $this->error_notification('Failed!', $response['message']);
            }
        } else {
            $this->closeModal();
            $this->success_notification('Success', 'No changes');
        }
    }


    public function closeModal()
    {
        $this->editDeviceModal = false;
        $this->dispatch('refresh-devices-list');
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.edit-device');
    }
}
