<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\API\WhatsappGateway;
use App\Services\WhatsappGateway\GatewayApiService;

class Payment extends Component
{
    use NotificationTrait;
    public $paymentModal = false;
    public $input = [];
    public $paymentMethods = [];
    public $invoice, $order, $company, $instructions, $invoice_id;

    public $currentStep = 1;

    #[On('show-payment-modal')]
    public function showPaymentModal($invoiceID)
    {
        $this->reset();
        $response = (new GatewayApiService())->showRequest(WhatsappGateway::INVOICE, $invoiceID);
        if ($response['success']) {
            $data = $response['payload']['data'];
            $this->paymentModal = true;
            $this->order = $data['order'];
            if ($this->order) {
                $this->currentStep = 2;
            }
            $this->company = $data['company'];
            $this->invoice = $data['invoice'];
            $this->paymentMethods = $data['payment_methods'];
            $this->invoice_id = $invoiceID;
        } else {
            $this->error_notification('Error', $response['message']);
        }
    }

    public function processOrder()
    {
        Validator::make($this->input, [
            'payment_method' => ['required'],
        ])->validate();
        $response = (new GatewayApiService())->updateRequest(WhatsappGateway::INVOICE, $this->invoice_id, $this->input);
        if ($response['success']) {
            $this->currentStep = 2;
            $data = $response['payload']['data'];
            $this->input['paymentCode'] = $data['order']['pay_code'];
            $this->order = $data['order'];
        } else {
            $this->error_notification('Error', $response['message']);
        }
    }

    public function paymentInstructions()
    {
        $this->currentStep = 3;
        $this->instructions = json_decode($this->order['instructions'], true);
    }

    public function cancelOrder()
    {
        $response = (new GatewayApiService())->deleteRequest(WhatsappGateway::INVOICE, $this->invoice_id);

        if ($response['success']) {
            $this->success_notification('Success', $response['payload']['message']);
        } else {
            $this->error_notification('Failed', $response['message']);
        }
        $this->closeModal();

    }

    public function back($step)
    {
        $this->currentStep = $step;
    }

    public function closeModal()
    {
        $this->paymentModal = false;
        $this->dispatch('refresh-invoice-list');
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.payment');
    }
}
