<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Http\Controllers\API\WhatsappGateway;
use App\Services\WhatsappGateway\GatewayApiService;

class ScanBarcode extends Component
{
    use NotificationTrait;
    public $scanBarcodeModal = false;
    public $number;

    #[On('show-scan-barcode-modal')]
    public function showScanBarcodeModal($number)
    {
        $this->scanBarcodeModal = true;
        $this->number = $number;
        $response = (new GatewayApiService())->showRequest(WhatsappGateway::DEVICES, $number);

        if ($response['success']) {
            $this->dispatch('get-whatsapp-barcode', $response['payload']['data']['device'], [
                'url' => 'https://' . config('wa-griyanet.server_url') . ':' . config('wa-griyanet.server_port'),
                //'privatekey' => env('API_CLIENT_MESSAGE')
                'user-name' => env('API_USERNAME')
            ]);
        } else {
            $this->error_notification('Failed', $response['message']);
        }
    }

    #[On('close-scan-barcode-modal')]
    public function closeModal()
    {
        $this->scanBarcodeModal = false;
        // Cache::forget('whatsapp-gateway-device');
        //Cache::flush();
        $this->dispatch('refresh-devices-list');
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.scan-barcode');
    }
}
