<?php

namespace App\Livewire\Auth\Register;

use Livewire\Component;
use Illuminate\Http\Request;
use Livewire\Attributes\Layout;
use App\Http\Requests\Customers\CreateCustomerStepOneRequest;
use Illuminate\Support\Str;

class RegisterStepOne extends Component
{
    public $input = [];
    //public $sessionRegisterProfile;

    public function mount(Request $request)
    {
        $this->input['last_name'] = '';
        $sessionRegisterStepOne = $request->session()->get('register.stepOne');
        if ($sessionRegisterStepOne) {
            $this->input = array_merge([
                'first_name' => $sessionRegisterStepOne['first_name'] ?? '',
                'last_name' => $sessionRegisterStepOne['last_name'] ?? '',
                'gender' => $sessionRegisterStepOne['gender'] ?? '',
                'dob' => $sessionRegisterStepOne['dob'] ?? '',
            ]);
        }
    }

    public function register_step_one(Request $request): void
    {
        (new CreateCustomerStepOneRequest())->validate($this->input);

        $first_name = Str::trim($this->input['first_name']); // remove strips whitespace (or other characters) from the beginning and end of the given string
        $this->input['first_name'] = Str::deduplicate($first_name, ' '); //remove duplicate space

        if (!empty($this->input['last_name'])) {
            $last_name = Str::trim($this->input['last_name']); // remove strips whitespace (or other characters) from the beginning and end of the given string
            $this->input['last_name'] = Str::deduplicate($last_name, ' '); //remove duplicate space
        }
        $request->session()->put('register.stepOne', $this->input);
        $this->redirect(route('register.steptwo', absolute: false), navigate: true);
    }

    #[Layout('components.layouts.auth')]
    public function render()
    {
        return view('livewire.auth.register.register-step-one');
    }
}
